/*
 * Decompiled with CFR 0.152.
 */
package zeitbalken.logic;

import java.util.LinkedList;
import java.util.List;
import zeitbalken.gui.MainFrame;
import zeitbalken.logic.Event;
import zeitbalken.logic.TooManyIntersectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventHandler {
    private MainFrame parent;
    private List<Event> events = new LinkedList<Event>();

    public EventHandler(MainFrame parent) {
        this.parent = parent;
    }

    public void add(Event e) throws TooManyIntersectException {
        this.parent.getField_panel().getF_drawer().handleEvent(e);
        Object event_intersect = null;
        LinkedList<Event> event_list = new LinkedList<Event>();
        for (Event e2 : this.events) {
            if (!this.intersect(e, e2)) continue;
            event_list.add(e2);
        }
        if (event_list.size() > 1) {
            for (int i = 0; i < event_list.size(); ++i) {
                for (int j = 1 + i; j < event_list.size(); ++j) {
                    if (!this.intersect((Event)event_list.get(i), (Event)event_list.get(j))) continue;
                    throw new TooManyIntersectException("To many event-intersections!");
                }
            }
        }
        if (event_list.size() > 0) {
            int status_ints = 16;
            for (int i = 0; i < event_list.size(); ++i) {
                System.out.println("" + i + ": " + ((Event)event_list.get(i)).getStatus_row());
                if (((Event)event_list.get(i)).getStatus_row() != 16) {
                    if (status_ints != 16 && status_ints != ((Event)event_list.get(i)).getStatus_row()) {
                        throw new TooManyIntersectException("To many event-intersections!");
                    }
                    status_ints = ((Event)event_list.get(i)).getStatus_row();
                    continue;
                }
                System.out.println("change status_ints");
                status_ints = ((Event)event_list.get(i)).getStatus_row();
            }
            if (status_ints != 16) {
                if (status_ints == 17) {
                    e.setStatus_row(18);
                    for (Event ev : event_list) {
                        ev.setStatus_row(17);
                    }
                } else {
                    e.setStatus_row(17);
                    for (Event ev : event_list) {
                        ev.setStatus_row(18);
                    }
                }
            } else {
                e.setStatus_row(17);
                for (Event ev : event_list) {
                    ev.setStatus_row(18);
                }
            }
        }
        this.parent.getField_panel().add(e.getjLabel_text());
        this.events.add(e);
    }

    public void remove(Event e) {
        if (this.events.remove(e)) {
            this.parent.getField_panel().remove(e.getjLabel_text());
            if (e.getStatus_row() != 16) {
                Event[] e_list = this.listIntersects(e);
                int sec_insects = 0;
                for (int i = 0; i < e_list.length; ++i) {
                    sec_insects = this.listIntersects(e_list[i]).length;
                    if (sec_insects != 1) continue;
                    e_list[i].setStatus_row(16);
                }
            }
        }
    }

    private Event[] listIntersects(Event e) {
        LinkedList<Event> list = new LinkedList<Event>();
        for (Event event : this.events) {
            if (!this.intersect(event, e)) continue;
            list.add(event);
        }
        Event[] e_arr = new Event[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            e_arr[i] = (Event)list.get(i);
        }
        return e_arr;
    }

    public Event[] intersectAt(int posX, int posY) {
        LinkedList<Event> events_list = new LinkedList<Event>();
        for (Event e : this.events) {
            if (e.getPosX() > posX || e.getPosX() + e.getWidth() < posX || e.getPosY() > posY || e.getPosY() + e.getHeight() < posY) continue;
            events_list.add(e);
        }
        return (Event[])events_list.toArray();
    }

    public Event[] intersectAtX(int zeile, int posX) {
        LinkedList<Event> events_list = new LinkedList<Event>();
        for (Event e : this.events) {
            if (e.getZeile() != zeile || e.getPosX() > posX || e.getPosX() + e.getWidth() < posX) continue;
            events_list.add(e);
        }
        return (Event[])events_list.toArray();
    }

    public boolean intersect(Event e1, Event e2) {
        if (e1.getZeile() != e2.getZeile()) {
            return false;
        }
        int i = e1.compareTo(e2);
        if (i > 0) {
            Event e_swap = e1;
            e1 = e2;
            e2 = e_swap;
        }
        if (e1.getStatus_event() == 2 && e2.getStatus_event() == 2) {
            return Math.abs(e1.getPosXPunkt() - e2.getPosXPunkt()) < 2;
        }
        if (e1.getStatus_event() == 2 || e2.getStatus_event() == 2) {
            return e1.getStatus_event() == 2 ? e1.getPosXPunkt() >= e2.getPosX() && e1.getPosXPunkt() <= e2.getPosX() + e2.getWidth() : e2.getPosXPunkt() >= e1.getPosX() && e2.getPosXPunkt() <= e1.getPosX() + e1.getWidth();
        }
        return e1.getPosX() + e1.getWidth() >= e2.getPosX();
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public void setEvents(List<Event> events) {
        this.events = events;
    }

    public MainFrame getParent() {
        return this.parent;
    }
}

