/*
 * Decompiled with CFR 0.152.
 */
package zeitbalken.gui;

import com.itextpdf.text.Document;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import zeitbalken.dialog.AnkerpersonDlg;
import zeitbalken.dialog.ColorChangerDlg;
import zeitbalken.dialog.EventDlg;
import zeitbalken.dialog.ExpandDlg;
import zeitbalken.dialog.GreetingDlg;
import zeitbalken.dialog.InfoDlg;
import zeitbalken.dialog.OptionsDlg;
import zeitbalken.gui.FieldDrawer;
import zeitbalken.gui.FieldPanel;
import zeitbalken.logic.Event;
import zeitbalken.logic.ImageStore;
import zeitbalken.logic.StreamGobbler;
import zeitbalken.logic.TooManyIntersectException;

public class MainFrame
extends JFrame {
    private FieldPanel field_panel = null;
    private JScrollPane scrollpane = null;
    private int screensize_x_half;
    private int screensize_y_half;
    private File savedFile;
    private int expand;
    ColorChangerDlg colorChangerDlg;
    private JButton jBGrafikSpeichern;
    private JButton jBNeu;
    private JButton jB_Einstellungen;
    private JButton jB_Expand;
    private JButton jB_Laden;
    private JButton jB_NewEvent;
    private JButton jB_Speichern;
    private JButton jB_SpeichernUnter;
    private JButton jButton1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar jToolBar1;

    public MainFrame() {
        this.screensize_x_half = Toolkit.getDefaultToolkit().getScreenSize().width;
        this.screensize_y_half = Toolkit.getDefaultToolkit().getScreenSize().height;
        this.savedFile = null;
        this.expand = 1;
        this.initComponents();
        this.jToolBar1.setFloatable(false);
        this.scrollpane = new JScrollPane();
        this.screensize_x_half /= 2;
        this.screensize_y_half /= 2;
        boolean finish_greeting = false;
        do {
            GreetingDlg greet = new GreetingDlg((Frame)this, true);
            greet.setLocation(this.screensize_x_half - greet.getWidth() / 2, this.screensize_y_half - greet.getHeight() / 2);
            greet.setVisible(true);
            if (greet.isNeu()) {
                AnkerpersonDlg ank_dlg = new AnkerpersonDlg((Frame)this, true);
                ank_dlg.setLocation(this.screensize_x_half - ank_dlg.getWidth() / 2, this.screensize_y_half - ank_dlg.getHeight() / 2);
                ank_dlg.setVisible(true);
                if (ank_dlg.isOk()) {
                    this.field_panel = new FieldPanel(this, ank_dlg.getGeb_monat(), ank_dlg.getGeb_jahr());
                    this.field_panel.setAnkerperson(ank_dlg.getAnkerperson());
                    this.field_panel.setGeburtsort(ank_dlg.getGeburtsort());
                    this.field_panel.setErsteller(ank_dlg.getErsteller());
                    Date date = new Date();
                    this.field_panel.setErstellDatum("" + date.getDate() + "." + (date.getMonth() + 1) + "." + (date.getYear() + 1900));
                    finish_greeting = true;
                }
            }
            if (!greet.isLaden()) continue;
            JFileChooser chooser = new JFileChooser(new File("."));
            chooser.setFileFilter(new FileNameExtensionFilter("Zeitbalken Datei", "bio"));
            int ret = chooser.showOpenDialog(null);
            if (ret != 0) continue;
            if (this.loadFromData(chooser.getSelectedFile())) {
                finish_greeting = true;
                continue;
            }
            JOptionPane.showMessageDialog(this, "Ein Fehler ist beim Laden der Datei entstanden. Bitte versuchen sie es erneut.", "Ladefehler", 1);
        } while (!finish_greeting);
        if (this.field_panel.getAlter() > 30) {
            if (this.field_panel.getAlter() > 60) {
                this.setExpand(3);
            } else {
                this.setExpand(2);
            }
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (MainFrame.this.field_panel != null && MainFrame.this.field_panel.getEvent_handler().getEvents().size() > 0) {
                    int ret = JOptionPane.showOptionDialog(MainFrame.this.field_panel.getEvent_handler().getParent(), "Wollen Sie die Datei speichern, bevor Sie das Programm beenden?", "Sicherheitsfrage", 1, 3, null, null, null);
                    if (ret == 0) {
                        if (MainFrame.this.savedFile != null) {
                            MainFrame.this.jB_SpeichernActionPerformed(null);
                        } else {
                            boolean isSave = MainFrame.this.saveAsData();
                            if (!isSave) {
                                return;
                            }
                        }
                    }
                    if (ret == 2) {
                        return;
                    }
                }
                System.exit(0);
            }
        });
        this.manageProperties();
        this.scrollpane.setVerticalScrollBarPolicy(20);
        this.scrollpane.setHorizontalScrollBarPolicy(30);
        this.scrollpane.setViewportView(this.field_panel);
        this.getContentPane().add((Component)this.scrollpane, "Center");
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jBNeu = new JButton();
        this.jB_Speichern = new JButton();
        this.jB_SpeichernUnter = new JButton();
        this.jB_Laden = new JButton();
        this.jBGrafikSpeichern = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jB_Einstellungen = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jB_NewEvent = new JButton();
        this.jB_Expand = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("easybiograph alpha 1.2.1");
        this.setMinimumSize(new Dimension(1000, 815));
        this.jToolBar1.setRollover(true);
        this.jBNeu.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/new doc.png")));
        this.jBNeu.setText("Neu");
        this.jBNeu.setFocusable(false);
        this.jBNeu.setHorizontalTextPosition(0);
        this.jBNeu.setVerticalTextPosition(3);
        this.jBNeu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jBNeuActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBNeu);
        this.jB_Speichern.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/save.png")));
        this.jB_Speichern.setText("Speichern");
        this.jB_Speichern.setFocusable(false);
        this.jB_Speichern.setHorizontalTextPosition(0);
        this.jB_Speichern.setVerticalTextPosition(3);
        this.jB_Speichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_SpeichernActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Speichern);
        this.jB_SpeichernUnter.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/save_as.png")));
        this.jB_SpeichernUnter.setText("Speichern unter ...");
        this.jB_SpeichernUnter.setFocusable(false);
        this.jB_SpeichernUnter.setHorizontalTextPosition(0);
        this.jB_SpeichernUnter.setVerticalTextPosition(3);
        this.jB_SpeichernUnter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_SpeichernUnterActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_SpeichernUnter);
        this.jB_Laden.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/open alt.png")));
        this.jB_Laden.setText("Laden");
        this.jB_Laden.setFocusable(false);
        this.jB_Laden.setHorizontalTextPosition(0);
        this.jB_Laden.setVerticalTextPosition(3);
        this.jB_Laden.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_LadenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Laden);
        this.jBGrafikSpeichern.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/picture.png")));
        this.jBGrafikSpeichern.setText("Grafik speichern");
        this.jBGrafikSpeichern.setFocusable(false);
        this.jBGrafikSpeichern.setHorizontalTextPosition(0);
        this.jBGrafikSpeichern.setVerticalTextPosition(3);
        this.jBGrafikSpeichern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jBGrafikSpeichernActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBGrafikSpeichern);
        this.jToolBar1.add(this.jSeparator1);
        this.jB_Einstellungen.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/einstellungen.png")));
        this.jB_Einstellungen.setText("Einstellungen");
        this.jB_Einstellungen.setFocusable(false);
        this.jB_Einstellungen.setHorizontalTextPosition(0);
        this.jB_Einstellungen.setVerticalTextPosition(3);
        this.jB_Einstellungen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_EinstellungenActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Einstellungen);
        this.jToolBar1.add(this.jSeparator2);
        this.jB_NewEvent.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/plus.png")));
        this.jB_NewEvent.setText("Ereignis");
        this.jB_NewEvent.setToolTipText("Neues Ereignis");
        this.jB_NewEvent.setFocusable(false);
        this.jB_NewEvent.setHorizontalTextPosition(0);
        this.jB_NewEvent.setVerticalTextPosition(3);
        this.jB_NewEvent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_NewEventActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_NewEvent);
        this.jB_Expand.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/expand.png")));
        this.jB_Expand.setText("Zoom");
        this.jB_Expand.setFocusable(false);
        this.jB_Expand.setHorizontalTextPosition(0);
        this.jB_Expand.setVerticalTextPosition(3);
        this.jB_Expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jB_ExpandActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jB_Expand);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/zeitbalken/icons/info.png")));
        this.jButton1.setText("Info");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.getContentPane().add((Component)this.jToolBar1, "First");
        this.pack();
    }

    private void jB_NewEventActionPerformed(ActionEvent evt) {
        EventDlg event = new EventDlg((Frame)this, true);
        event.deleteLoeschen();
        event.setVisible(true);
        if (event.isOk()) {
            Event ev = new Event(this.field_panel.getEvent_handler());
            this.saveDlgToEvent(event, ev);
            try {
                this.field_panel.getEvent_handler().add(ev);
            }
            catch (TooManyIntersectException tmie) {
                System.out.println("TooManyIntersectException: " + tmie.getMessage() + "\n");
                JOptionPane.showOptionDialog(this, "Das neue Event \u00fcberschneidet mit mehr als nur einem weiteren Event und kann deswegen nicht platziert werden.", "\u00dcberschneidungsproblem", 1, -1, null, null, this.rootPane);
            }
            this.repaint();
        }
    }

    private void jB_SpeichernActionPerformed(ActionEvent evt) {
        if (this.savedFile != null) {
            this.saveData(this.savedFile);
        } else {
            if (this.field_panel.getAnkerperson().equals("")) {
                JOptionPane.showMessageDialog(this, "Bitte geben sie der Person einen Namen und speichern Sie erneut.", "Problem beim speichern", 2);
                return;
            }
            this.savedFile = new File("." + File.separator + "clients");
            if (this.savedFile.exists() && this.savedFile.isDirectory() || this.savedFile.mkdir()) {
                this.savedFile = new File("." + File.separator + "clients" + File.separator + this.field_panel.getAnkerperson());
                if (this.savedFile.exists() && this.savedFile.isDirectory() || this.savedFile.mkdir()) {
                    this.savedFile = new File(this.savedFile.getAbsoluteFile() + File.separator + this.field_panel.getAnkerperson() + ".bio");
                    this.saveData(this.savedFile);
                } else {
                    JOptionPane.showMessageDialog(this, "Ein Fehler ist aufgetreten. Bitte versuchen sie es erneut.", "Fehler", 2);
                }
            }
            System.out.println("Datei nicht vorhanden!");
        }
    }

    private void jB_LadenActionPerformed(ActionEvent evt) {
        int ret;
        if (this.field_panel.getEvent_handler().getEvents().size() > 0 && (ret = JOptionPane.showOptionDialog(this, "Beim Laden geht das aktuelle Projekt verloren. Wollen sie fortfahren?", "Laden fortfahren?", 0, 3, null, null, null)) == 1) {
            return;
        }
        JFileChooser chooser = new JFileChooser(new File("."));
        chooser.setFileFilter(new FileNameExtensionFilter("Zeitbalken Datei", "bio"));
        int ret2 = chooser.showOpenDialog(this);
        if (ret2 == 0) {
            if (this.loadFromData(chooser.getSelectedFile())) {
                this.savedFile = chooser.getSelectedFile();
                this.repaint();
            } else {
                JOptionPane.showMessageDialog(this, "Ein Fehler ist beim Laden der Datei entstanden. Bitte versuchen sie es erneut.", "Ladefehler", 1);
            }
        }
    }

    private void jB_SpeichernUnterActionPerformed(ActionEvent evt) {
        this.saveAsData();
    }

    private boolean saveAsData() throws HeadlessException {
        JFileChooser chooser = new JFileChooser(new File("."));
        chooser.setFileFilter(new FileNameExtensionFilter("Zeitbalken Datei", "bio"));
        int ret = chooser.showSaveDialog(this);
        if (ret == 0) {
            if (this.saveData(chooser.getSelectedFile())) {
                this.savedFile = chooser.getSelectedFile();
                this.repaint();
                return true;
            }
            JOptionPane.showMessageDialog(this, "Ein Fehler ist beim Speichern der Datei entstanden. Bitte versuchen sie es erneut.", "Ladefehler", 1);
            return false;
        }
        return false;
    }

    private void jB_ExpandActionPerformed(ActionEvent evt) {
        ExpandDlg expand_dlg = new ExpandDlg((Frame)this, true);
        expand_dlg.setExpand(this.expand);
        expand_dlg.setLocation(this.screensize_x_half - expand_dlg.getWidth() / 2, this.screensize_y_half - expand_dlg.getHeight() / 2);
        expand_dlg.setVisible(true);
        if (expand_dlg.isOk()) {
            this.setExpand(expand_dlg.getExpand());
        }
    }

    private void jB_EinstellungenActionPerformed(ActionEvent evt) {
        OptionsDlg optDlg = new OptionsDlg((Frame)this, false);
        optDlg.setLocation(this.screensize_x_half - optDlg.getWidth() / 2, this.screensize_y_half - optDlg.getHeight() / 2);
        optDlg.setVisible(true);
    }

    private void jBNeuActionPerformed(ActionEvent evt) {
        Process proc = null;
        try {
            File file = new File(".");
            File[] f_return = file.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getAbsolutePath().endsWith(".jar") && pathname.getName().startsWith("easy");
                }
            });
            String cmd = "java -jar \"";
            if (f_return.length == 1) {
                cmd = cmd + f_return[0].getCanonicalFile() + "\"";
            }
            Runtime rt = Runtime.getRuntime();
            if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                System.out.println("mac found");
                String[] cmd_mac = new String[]{"java", "-jar", f_return[0].getCanonicalFile().toString()};
                proc = rt.exec(cmd_mac);
            } else {
                proc = rt.exec(cmd);
            }
            System.out.println("\n   cmd: " + cmd + "\n");
            System.out.println("OS: " + System.getProperty("os.name") + " \n");
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUT");
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Throwable t) {
            if (proc != null) {
                System.out.println("exitValue: " + proc.exitValue());
            }
            t.printStackTrace();
        }
    }

    private void jBGrafikSpeichernActionPerformed(ActionEvent evt) {
        this.jB_SpeichernActionPerformed(evt);
        ImageStore istore = new ImageStore(this.field_panel);
        BufferedImage b_img = null;
        String filename = null;
        if (this.savedFile != null) {
            filename = this.savedFile.getParent() + File.separatorChar + this.field_panel.getAnkerperson().replace(" ", "_");
            System.out.println("filename: " + filename);
        }
        File file_png = new File(filename + ".png");
        try {
            istore.store(this.field_panel.getWidth(), this.field_panel.getHeight(), file_png.getAbsolutePath());
            b_img = ImageIO.read(file_png);
            if (this.getExpand() > 1) {
                BufferedImage subImg = null;
                switch (this.getExpand()) {
                    case 4: {
                        subImg = b_img.getSubimage(2600, 0, 800, b_img.getHeight());
                        ImageIO.write((RenderedImage)subImg, "png", new File("" + filename + "04.png"));
                    }
                    case 3: {
                        subImg = b_img.getSubimage(1800, 0, 800, b_img.getHeight());
                        ImageIO.write((RenderedImage)subImg, "png", new File("" + filename + "03.png"));
                    }
                    case 2: {
                        subImg = b_img.getSubimage(1000, 0, 800, b_img.getHeight());
                        ImageIO.write((RenderedImage)subImg, "png", new File("" + filename + "02.png"));
                        subImg = b_img.getSubimage(0, 0, 1000, b_img.getHeight());
                        ImageIO.write((RenderedImage)subImg, "png", new File("" + filename + "01.png"));
                        break;
                    }
                    default: {
                        System.out.println("Expand higher then expected");
                    }
                }
            }
            Document document = null;
            PdfWriter writer = null;
            Image img1 = null;
            if (this.getExpand() > 1) {
                document = new Document(new Rectangle(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
                writer = PdfWriter.getInstance(document, new FileOutputStream(new File(filename + "_expand.pdf").getAbsoluteFile()));
                writer.setPageEvent(new PdfPageEvent(){

                    public void onOpenDocument(PdfWriter writer, Document dcmnt) {
                    }

                    public void onStartPage(PdfWriter writer, Document dcmnt) {
                    }

                    public void onEndPage(PdfWriter writer, Document dcmnt) {
                        PdfContentByte cb = writer.getDirectContent();
                        BaseFont helv = null;
                        try {
                            helv = BaseFont.createFont("Helvetica", "Cp1252", false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        cb.beginText();
                        cb.setFontAndSize(helv, 12.0f);
                        cb.setTextMatrix(dcmnt.left(), dcmnt.bottom() - 20.0f);
                        cb.showText("" + MainFrame.this.field_panel.getAnkerperson());
                        cb.setTextMatrix(dcmnt.right() - 55.0f, dcmnt.bottom() - 20.0f);
                        cb.showText("Seite " + writer.getPageNumber() + "/" + MainFrame.this.field_panel.getMainFrame().getExpand());
                        cb.endText();
                    }

                    public void onCloseDocument(PdfWriter writer, Document dcmnt) {
                    }

                    public void onParagraph(PdfWriter writer, Document dcmnt, float f) {
                    }

                    public void onParagraphEnd(PdfWriter writer, Document dcmnt, float f) {
                    }

                    public void onChapter(PdfWriter writer, Document dcmnt, float f, Paragraph prgrph) {
                    }

                    public void onChapterEnd(PdfWriter writer, Document dcmnt, float f) {
                    }

                    public void onSection(PdfWriter writer, Document dcmnt, float f, int i, Paragraph prgrph) {
                    }

                    public void onSectionEnd(PdfWriter writer, Document dcmnt, float f) {
                    }

                    public void onGenericTag(PdfWriter writer, Document dcmnt, Rectangle rctngl, String string) {
                    }
                });
                document.open();
                img1 = null;
                for (int i = 1; i <= this.getExpand(); ++i) {
                    img1 = Image.getInstance(filename + "0" + i + ".png");
                    img1.scaleToFit(7600.0f, 500.0f);
                    img1.setAlignment(0);
                    document.add(img1);
                    document.newPage();
                }
                document.close();
            }
            document = new Document(new Rectangle(PageSize.A4.getHeight(), PageSize.A4.getWidth()));
            writer = PdfWriter.getInstance(document, new FileOutputStream(new File(filename + ".pdf").getAbsoluteFile()));
            writer.setPageEvent(new PdfPageEvent(){

                public void onOpenDocument(PdfWriter writer, Document dcmnt) {
                }

                public void onStartPage(PdfWriter writer, Document dcmnt) {
                }

                public void onEndPage(PdfWriter writer, Document dcmnt) {
                    PdfContentByte cb = writer.getDirectContent();
                    BaseFont helv = null;
                    try {
                        helv = BaseFont.createFont("Helvetica", "Cp1252", false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    cb.beginText();
                    cb.setFontAndSize(helv, 12.0f);
                    cb.setTextMatrix(dcmnt.left(), dcmnt.bottom() - 20.0f);
                    cb.showText("" + MainFrame.this.field_panel.getAnkerperson());
                    cb.setTextMatrix(dcmnt.right() - 55.0f, dcmnt.bottom() - 20.0f);
                    cb.showText("Seite " + writer.getPageNumber() + "/1");
                    cb.endText();
                }

                public void onCloseDocument(PdfWriter writer, Document dcmnt) {
                }

                public void onParagraph(PdfWriter writer, Document dcmnt, float f) {
                }

                public void onParagraphEnd(PdfWriter writer, Document dcmnt, float f) {
                }

                public void onChapter(PdfWriter writer, Document dcmnt, float f, Paragraph prgrph) {
                }

                public void onChapterEnd(PdfWriter writer, Document dcmnt, float f) {
                }

                public void onSection(PdfWriter writer, Document dcmnt, float f, int i, Paragraph prgrph) {
                }

                public void onSectionEnd(PdfWriter writer, Document dcmnt, float f) {
                }

                public void onGenericTag(PdfWriter writer, Document dcmnt, Rectangle rctngl, String string) {
                }
            });
            document.open();
            img1 = Image.getInstance(filename + ".png");
            img1.scaleToFit(760.0f, 500.0f);
            img1.setAlignment(0);
            document.add(img1);
            document.close();
            JOptionPane.showMessageDialog(this, "Die Daten sind gespeichert.", "Speichern abgeschlossen", 1);
            String cmd = "explorer.exe " + this.savedFile.getParent();
            Runtime rt = Runtime.getRuntime();
            Process proc = null;
            proc = System.getProperty("os.name").toLowerCase().contains("mac") ? rt.exec(new String[]{"open", this.savedFile.getParent()}) : rt.exec(cmd);
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUT");
            errorGobbler.start();
            outputGobbler.start();
        }
        catch (Exception ex) {
            Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        InfoDlg idlg = new InfoDlg((Frame)this, true);
        idlg.setLocation(this.getScreensize_xHalf() - idlg.getWidth() / 2, this.getScreensize_yHalf() - idlg.getHeight() / 2);
        idlg.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveData(File file) {
        FileWriter f_write = null;
        BufferedWriter b_write = null;
        String writeString = "";
        if (!file.getName().toLowerCase().endsWith(".bio")) {
            file = new File(file.getPath() + ".bio");
        }
        try {
            f_write = new FileWriter(file);
            b_write = new BufferedWriter(f_write);
            b_write.write("FP;" + this.field_panel.getAnkerperson() + ";" + this.field_panel.getGb_monat() + ";" + this.field_panel.getGb_jahr() + ";" + this.field_panel.getGeburtsort() + ";" + this.field_panel.getErsteller() + ";" + this.field_panel.getErstellDatum());
            b_write.newLine();
            b_write.write("O;" + this.expand);
            b_write.newLine();
            b_write.write("ZB;" + this.field_panel.getF_drawer().getLine07() + ";" + this.field_panel.getF_drawer().getLine08());
            b_write.newLine();
            for (int i = 0; i < this.field_panel.getEvent_handler().getEvents().size(); ++i) {
                Event e = this.field_panel.getEvent_handler().getEvents().get(i);
                writeString = "E;" + e.getStatus_event() + ";" + e.getStatus_row() + ";" + e.getStatus_ende() + ";" + e.getZeile() + ";" + e.getMonat_von() + ";" + e.getMonat_bis() + ";" + e.getJahr_von() + ";" + e.getJahr_bis() + ";" + e.getText() + ";" + e.isIS_MOVABLE() + ";";
                writeString = e.getPolygon_movable() != null ? writeString + e.getPolygon_movable().getBounds().x + ";" + e.getPolygon_movable().getBounds().y : writeString + "0;0";
                b_write.write(writeString);
                b_write.newLine();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                b_write.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadFromData(File file) {
        BufferedReader bread = null;
        String line = "";
        String[] line_split = null;
        try {
            bread = new BufferedReader(new FileReader(file));
            line = bread.readLine();
            if (line == null) {
                System.out.println("Fehler");
                boolean bl = false;
                return bl;
            }
            line_split = line.split(";");
            System.out.println("line_split: " + line_split[0]);
            if (line_split[0].endsWith("FP")) {
                if (this.field_panel != null) {
                    this.scrollpane.remove(this.field_panel);
                }
                this.field_panel = new FieldPanel(this, new Integer(line_split[2]), new Integer(line_split[3]));
                this.field_panel.setAnkerperson(line_split[1]);
                if (line_split.length > 4) {
                    this.field_panel.setGeburtsort(line_split[4]);
                }
                if (line_split.length > 5) {
                    this.field_panel.setErsteller(line_split[5]);
                    this.field_panel.setErstellDatum(line_split[6]);
                }
                this.scrollpane.setViewportView(this.field_panel);
                this.validate();
            }
            while ((line = bread.readLine()) != null) {
                line_split = line.split(";");
                if (line_split[0].trim().endsWith("E")) {
                    Event event = new Event(this.field_panel.getEvent_handler());
                    event.setStatus_event(new Integer(line_split[1]));
                    event.setStatus_ende(new Integer(line_split[3]));
                    event.setZeile(new Integer(line_split[4]));
                    event.setMonat_von(new Integer(line_split[5]));
                    event.setMonat_bis(new Integer(line_split[6]));
                    event.setJahr_von(new Integer(line_split[7]));
                    event.setJahr_bis(new Integer(line_split[8]));
                    event.setText(line_split[9]);
                    event.setIS_MOVABLE(Boolean.valueOf(line_split[10]));
                    this.field_panel.getEvent_handler().add(event);
                    if (Boolean.valueOf(line_split[10]).booleanValue()) {
                        event.repositMovablePolygon(new Integer(line_split[11]), new Integer(line_split[12]));
                    }
                }
                if (line_split[0].trim().endsWith("O")) {
                    this.setExpand(new Integer(line_split[1]));
                }
                if (!line_split[0].trim().endsWith("ZB")) continue;
                this.field_panel.getF_drawer().setLine07(line_split[1]);
                if (line_split.length <= 2) continue;
                this.field_panel.getF_drawer().setLine08(line_split[2]);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (TooManyIntersectException tmiex) {
            tmiex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                bread.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MainFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return true;
    }

    public void saveDlgToEvent(EventDlg ev_dlg, Event ev) {
        if (ev_dlg.getjRBZeitPunkt().isSelected()) {
            ev.setStatus_event(2);
        } else {
            ev.setStatus_event(1);
        }
        ev.setZeile(ev_dlg.getjComboBox1().getSelectedIndex());
        ev.setMonat_von(ev_dlg.getjCBMonat_von().getSelectedIndex());
        ev.setJahr_von(new Integer(ev_dlg.getjCBJahr_von().getSelectedItem().toString()));
        if (ev.getStatus_event() == 1) {
            ev.setMonat_bis(ev_dlg.getjCBMonat_bis().getSelectedIndex());
            ev.setJahr_bis(new Integer(ev_dlg.getjCBJahr_bis().getSelectedItem().toString()));
        } else {
            ev.setMonat_bis(ev.getMonat_von() + 1);
            ev.setJahr_bis(ev.getJahr_von());
        }
        if (ev_dlg.hasEndOpen()) {
            ev.setStatus_ende(32);
        } else {
            ev.setStatus_ende(33);
        }
        ev.setText("<HTML>" + ev_dlg.getjTABeschreibung().getText().replace("\n", "<br>") + "</HTML>");
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainFrame().setVisible(true);
            }
        });
    }

    public FieldPanel getField_panel() {
        return this.field_panel;
    }

    public void setField_panel(FieldPanel field_panel) {
        this.field_panel = field_panel;
    }

    public int getScreensize_xHalf() {
        return this.screensize_x_half;
    }

    public int getScreensize_yHalf() {
        return this.screensize_y_half;
    }

    public int getExpand() {
        return this.expand;
    }

    private void setExpand(int expand) {
        this.expand = expand;
        this.field_panel.getF_drawer().setWidthPanelFDrawer(200 + 800 * expand);
    }

    public void startColorSettings() {
        this.colorChangerDlg = new ColorChangerDlg((Frame)this, false);
        this.colorChangerDlg.setLocation(this.screensize_x_half * 2 - this.colorChangerDlg.getWidth(), this.screensize_y_half - this.colorChangerDlg.getHeight() / 2);
        this.colorChangerDlg.setVisible(true);
    }

    private void manageProperties() {
        File file = new File("easybiograph.properties");
        if (!file.exists()) {
            this.createDefaultProperties(file);
        } else {
            this.loadProperties(file);
        }
    }

    public void saveProperties() {
        this.createDefaultProperties(new File("easybiograph.properties"));
    }

    public void loadProperties(File file) {
        FieldDrawer fdrawer = this.field_panel.getF_drawer();
        BufferedReader bread = null;
        try {
            bread = new BufferedReader(new FileReader(file));
            String line = "";
            while ((line = bread.readLine()) != null) {
                String[] lineArray = line.split(":");
                if (lineArray[0].equals("color_top")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_top(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_firstColumn")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_firstColumn(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_firstRow")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_firstRow(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_firstCell")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_firstCell(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_markedcolumns")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_markedColumns(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_left")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_left(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_CufOff")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_CutOff(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_TextHeadline")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_TextHeadline(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_TextFirstColum")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_TextFirstColum(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (lineArray[0].equals("color_TextFirstRow")) {
                    lineArray = lineArray[1].split(",");
                    fdrawer.setColor_TextFirstRows(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
                    continue;
                }
                if (!lineArray[0].equals("color_lines")) continue;
                lineArray = lineArray[1].split(",");
                fdrawer.setColor_lines(new Color(new Integer(lineArray[0]), new Integer(lineArray[1]), new Integer(lineArray[2])));
            }
            fdrawer.colorChangerDlgStarting();
            this.repaint();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultProperties(File file) {
        FieldDrawer fdrawer = this.field_panel.getF_drawer();
        BufferedWriter bwrite = null;
        try {
            bwrite = new BufferedWriter(new FileWriter(file));
            Color current_color = fdrawer.getColor_top();
            bwrite.write("color_top:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_firstColumn();
            bwrite.write("color_firstColumn:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_firstRow();
            bwrite.write("color_firstRow:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_firstCell();
            bwrite.write("color_firstCell:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_markedColumns();
            bwrite.write("color_markedColumns:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_left();
            bwrite.write("color_left:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_CutOff();
            bwrite.write("color_CufOff:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_TextHeadline();
            bwrite.write("color_TextHeadline:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_TextFirstColum();
            bwrite.write("color_TextFirstColum:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_TextFirstRows();
            bwrite.write("color_TextFirstRows:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
            current_color = fdrawer.getColor_lines();
            bwrite.write("color_llines:" + current_color.getRed() + "," + current_color.getGreen() + "," + current_color.getBlue());
            bwrite.newLine();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (bwrite != null) {
                try {
                    bwrite.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

