/*
 * Decompiled with CFR 0.152.
 */
package zeitbalken.logic;

import java.awt.Polygon;
import javax.swing.JLabel;
import zeitbalken.logic.EventHandler;

public class Event {
    public static final int EVENT_RAUM = 1;
    public static final int EVENT_PUNKT = 2;
    public static final int ROW_ONLY = 16;
    public static final int ROW_UP = 17;
    public static final int ROW_DOWN = 18;
    public static final int END_OPEN = 32;
    public static final int END_CLOSED = 33;
    private int zeile;
    private int monat_von = 0;
    private int jahr_von = 0;
    private int monat_bis = 0;
    private int jahr_bis = 0;
    private String text = "";
    private int status_event = 0;
    private int status_row = 16;
    private int status_ende;
    private JLabel jLabel_text = new JLabel();
    int posX;
    int posY;
    int width;
    int height;
    private Polygon polygon;
    private Polygon polygon_movable;
    int posXPunkt = 0;
    int posYPunkt = 0;
    int heightPunkt = 65;
    private EventHandler parent;
    private boolean IS_MOVABLE = false;
    private int length_moveable = 0;
    private int gap_left_move = 3;
    private int gap_right_move = 2;
    private int gap_overall_move = 5;
    private int gap_upNdown_move = 10;

    public Event(EventHandler parent) {
        this.parent = parent;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        if (this.zeile != other.zeile) {
            return false;
        }
        if (this.monat_von != other.monat_von) {
            return false;
        }
        if (this.jahr_von != other.jahr_von) {
            return false;
        }
        if (this.monat_bis != other.monat_bis) {
            return false;
        }
        if (this.jahr_bis != other.jahr_bis) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + this.zeile;
        hash = 67 * hash + this.jahr_von;
        hash = 67 * hash + this.jahr_bis;
        return hash;
    }

    public int compareTo(Event e) {
        if (this.getZeile() == e.getZeile()) {
            if (this.getJahr_von() == e.getJahr_von()) {
                if (this.getMonat_von() == e.getMonat_von()) {
                    return 0;
                }
                return this.getMonat_von() - e.getMonat_von();
            }
            return this.getJahr_von() - e.getJahr_von();
        }
        return this.getZeile() - e.getZeile();
    }

    private void constructPolygon() {
        this.polygon = new Polygon();
        if (this.getStatus_event() == 1) {
            this.polygon.addPoint(this.posX, this.posY);
            if (this.status_ende == 33) {
                this.polygon.addPoint(this.posX + this.width, this.posY);
            } else {
                this.polygon.addPoint(this.posX + this.width - 10, this.posY);
            }
            this.polygon.addPoint(this.posX + this.width, this.posY + this.height);
            this.polygon.addPoint(this.posX, this.posY + this.height);
        } else {
            this.polygon.addPoint(this.posXPunkt - 1, this.posYPunkt);
            this.polygon.addPoint(this.posXPunkt + 1, this.posYPunkt);
            this.polygon.addPoint(this.posXPunkt + 1, this.posYPunkt + this.heightPunkt);
            this.polygon.addPoint(this.posXPunkt - 1, this.posYPunkt + this.heightPunkt);
        }
    }

    private void constructMoveablePolygon() {
        if (!this.IS_MOVABLE) {
            return;
        }
        this.polygon_movable = new Polygon();
        int rowcount = this.text.split("<br>").length;
        int t_x = this.posX + 20;
        int t_y = this.posY + 10;
        int t_w = this.length_moveable = this.getTextMaxLength();
        int t_h = this.jLabel_text.getFont().getSize();
        this.polygon_movable.addPoint(t_x, t_y);
        this.polygon_movable.addPoint(t_x + t_w + this.gap_overall_move, t_y);
        this.polygon_movable.addPoint(t_x + t_w + this.gap_overall_move, t_y + t_h * rowcount + this.gap_upNdown_move);
        this.polygon_movable.addPoint(t_x, t_y + t_h * rowcount + this.gap_upNdown_move);
        this.jLabel_text.setBounds(t_x + this.gap_left_move, t_y, t_w, t_h * rowcount + this.gap_upNdown_move);
    }

    public void repositMovablePolygon(int posX, int posY) {
        if (!this.IS_MOVABLE) {
            return;
        }
        int h = (int)this.polygon_movable.getBounds().getHeight();
        this.polygon_movable = new Polygon();
        this.polygon_movable.addPoint(posX, posY);
        this.polygon_movable.addPoint(posX + this.getTextMaxLength() + this.gap_overall_move, posY);
        this.polygon_movable.addPoint(posX + this.getTextMaxLength() + this.gap_overall_move, posY + h);
        this.polygon_movable.addPoint(posX, posY + h);
        this.jLabel_text.setLocation(posX, posY);
        this.jLabel_text.setBounds(posX + this.gap_left_move, posY, this.getTextMaxLength(), h);
    }

    public int getJahr_bis() {
        return this.jahr_bis;
    }

    public void setJahr_bis(int jahr_bis) {
        this.jahr_bis = jahr_bis;
    }

    public int getJahr_von() {
        return this.jahr_von;
    }

    public void setJahr_von(int jahr_von) {
        this.jahr_von = jahr_von;
    }

    public int getMonat_bis() {
        return this.monat_bis;
    }

    public void setMonat_bis(int monat_bis) {
        this.monat_bis = monat_bis;
    }

    public int getMonat_von() {
        return this.monat_von;
    }

    public void setMonat_von(int monat_von) {
        this.monat_von = monat_von;
    }

    public String getText() {
        return this.text;
    }

    public String getTextNonHTML() {
        return this.text.replace("<HTML>", "").replace("</HTML>", "").replace("<br>", "\n");
    }

    public int getTextMaxLength() {
        String s = this.text.replace("<HTML>", "").replace("</HTML>", "");
        String[] s_array = s.split("<br>");
        int len = 0;
        int len_new = 0;
        for (int i = 0; i < s_array.length; ++i) {
            len_new = this.parent.getParent().getField_panel().getF_drawer().getFont_metrics().stringWidth(s_array[i]);
            if (len >= len_new) continue;
            len = len_new;
        }
        return len;
    }

    public void setText(String text) {
        this.text = text;
        this.jLabel_text.setText(text);
    }

    public int getZeile() {
        return this.zeile;
    }

    public void setZeile(int zeile) {
        this.zeile = zeile;
    }

    public int getStatus_event() {
        return this.status_event;
    }

    public void setStatus_event(int status) {
        this.status_event = status;
        this.constructPolygon();
    }

    public JLabel getjLabel_text() {
        return this.jLabel_text;
    }

    public void setjLabel_text(JLabel jLabel_text) {
        this.jLabel_text = jLabel_text;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
        if (this.status_event == 1) {
            this.jLabel_text.setBounds(this.posX, this.posY, this.width, height);
        }
        this.constructPolygon();
    }

    public int getPosX() {
        return this.posX;
    }

    public void setPosX(int posX) {
        this.posX = posX;
        if (this.status_event == 1) {
            this.jLabel_text.setBounds(posX, this.posY, this.width, this.height);
        }
        this.constructPolygon();
    }

    public int getPosY() {
        return this.posY;
    }

    public void setPosY(int posY) {
        this.posY = posY;
        if (this.status_event == 1) {
            this.jLabel_text.setBounds(this.posX, posY, this.width, this.height);
        }
        this.constructPolygon();
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
        if (this.status_event == 1) {
            this.jLabel_text.setBounds(this.posX, this.posY, width, this.height);
        }
        this.constructPolygon();
    }

    public int getStatus_row() {
        return this.status_row;
    }

    public void setStatus_row(int status_row) {
        if (this.status_row == 16) {
            if (status_row == 17) {
                this.setHeight(30);
                this.heightPunkt = 30;
            }
            if (status_row == 18) {
                this.posYPunkt += 35;
                this.posY += 35;
                this.setHeight(30);
                this.heightPunkt = 30;
            }
        }
        if (this.status_row == 17) {
            if (status_row == 16) {
                this.setHeight(65);
                this.heightPunkt = 65;
            }
            if (status_row == 18) {
                this.posYPunkt += 35;
                this.posY += 35;
            }
        }
        if (this.status_row == 18) {
            if (status_row == 17) {
                this.posYPunkt -= 35;
                this.posY -= 35;
            }
            if (status_row == 16) {
                this.posYPunkt -= 35;
                this.posY -= 35;
                this.setHeight(65);
                this.heightPunkt = 65;
            }
        }
        this.status_row = status_row;
    }

    public int getHeightPunkt() {
        return this.heightPunkt;
    }

    public void setHeightPunkt(int heightPunkt) {
        this.heightPunkt = heightPunkt;
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public int getStatus_ende() {
        return this.status_ende;
    }

    public void setStatus_ende(int status_ende) {
        this.status_ende = status_ende;
    }

    public boolean isIS_MOVABLE() {
        return this.IS_MOVABLE;
    }

    public void setIS_MOVABLE(boolean IS_MOVABLE) {
        this.IS_MOVABLE = IS_MOVABLE;
        if (IS_MOVABLE) {
            this.constructMoveablePolygon();
        }
    }

    public Polygon getPolygon_movable() {
        return this.polygon_movable;
    }

    public int getPosXPunkt() {
        return this.posXPunkt;
    }

    public void setPosXPunkt(int posXPunkt) {
        this.posXPunkt = posXPunkt;
    }

    public int getPosYPunkt() {
        return this.posYPunkt;
    }

    public void setPosYPunkt(int posYPunkt) {
        this.posYPunkt = posYPunkt;
    }
}

