/*
 * Decompiled with CFR 0.152.
 */
package zeitbalken.gui;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import zeitbalken.dialog.EventDlg;
import zeitbalken.gui.FieldDrawer;
import zeitbalken.gui.MainFrame;
import zeitbalken.logic.Event;
import zeitbalken.logic.EventHandler;
import zeitbalken.logic.TooManyIntersectException;

public class FieldPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private MainFrame mainFrame;
    private FieldDrawer f_drawer;
    private EventHandler event_handler;
    private int gb_monat = 0;
    private int gb_jahr = 0;
    private int alter = 0;
    private String ankerperson = "Max Mustermann";
    private String geburtsort = "";
    private String ersteller = "";
    private String erstellDatum = "";
    private int current_jahr;
    private int current_monat;
    private int posX1;
    private int posY1;
    private int posX2;
    private int posY2;
    private boolean stateMouseDragged = false;
    private Event event_move = null;
    private int pol_X = 0;
    private int pol_Y = 0;

    public FieldPanel(MainFrame mainFrame, int geb_monat, int geb_jahr) {
        this.initComponents();
        this.mainFrame = mainFrame;
        this.event_handler = new EventHandler(mainFrame);
        this.setPreferredSize(new Dimension(1000, 700));
        this.gb_monat = geb_monat;
        this.gb_jahr = geb_jahr;
        this.current_jahr = new Date().getYear() + 1900;
        this.current_monat = new Date().getMonth() + 1;
        this.alter = this.current_jahr - this.gb_jahr;
        if (new Date().getMonth() < this.gb_monat) {
            --this.alter;
        }
        this.f_drawer = new FieldDrawer(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public void paint(Graphics g) {
        this.f_drawer.draw(g, this.event_handler.getEvents());
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
    }

    public String getAnkerperson() {
        return this.ankerperson;
    }

    public void setAnkerperson(String ankerperson) {
        this.ankerperson = ankerperson;
    }

    public int getCurrent_jahr() {
        return this.current_jahr;
    }

    public void setCurrent_jahr(int current_jahr) {
        this.current_jahr = current_jahr;
    }

    public int getCurrent_monat() {
        return this.current_monat;
    }

    public void setCurrent_monat(int current_monat) {
        this.current_monat = current_monat;
    }

    public EventHandler getEvent_handler() {
        return this.event_handler;
    }

    public void setEvent_handler(EventHandler event_handler) {
        this.event_handler = event_handler;
    }

    public FieldDrawer getF_drawer() {
        return this.f_drawer;
    }

    public void setF_drawer(FieldDrawer f_drawer) {
        this.f_drawer = f_drawer;
    }

    public int getGb_jahr() {
        return this.gb_jahr;
    }

    public void setGb_jahr(int gb_jahr) {
        this.gb_jahr = gb_jahr;
    }

    public int getGb_monat() {
        return this.gb_monat;
    }

    public void setGb_monat(int gb_monat) {
        this.gb_monat = gb_monat;
    }

    public int getAlter() {
        return this.alter;
    }

    public void setAlter(int alter) {
        this.alter = alter;
    }

    public String getGeburtsort() {
        return this.geburtsort;
    }

    public void setGeburtsort(String geburtsort) {
        this.geburtsort = geburtsort;
    }

    public String getErsteller() {
        return this.ersteller;
    }

    public void setErsteller(String ersteller) {
        this.ersteller = ersteller;
    }

    public void mouseClicked(MouseEvent e) {
        this.posX1 = e.getPoint().x;
        this.posY1 = e.getPoint().y;
        Event ev_searched = null;
        for (Event event : this.event_handler.getEvents()) {
            if (event.getStatus_event() == 1 && this.posX1 >= event.getPosX() && this.posX1 <= event.getPosX() + event.getWidth() && this.posY1 >= event.getPosY() && this.posY1 <= event.getPosY() + event.getHeight()) {
                ev_searched = event;
                break;
            }
            if (!event.isIS_MOVABLE() || !event.getPolygon_movable().intersects(this.posX1, this.posY1, 1.0, 1.0)) continue;
            ev_searched = event;
            break;
        }
        if (ev_searched != null) {
            EventDlg ev_dlg = new EventDlg((Frame)this.mainFrame, true);
            ev_dlg.setEventtyp(ev_searched.getStatus_row());
            ev_dlg.getjCBMonat_von().setSelectedIndex(ev_searched.getMonat_von());
            ev_dlg.getjCBJahr_von().setSelectedItem(ev_searched.getJahr_von());
            if (ev_searched.getStatus_event() == 1) {
                ev_dlg.getjCBMonat_bis().setSelectedIndex(ev_searched.getMonat_bis());
                ev_dlg.getjCBJahr_bis().setSelectedItem(ev_searched.getJahr_bis());
            } else {
                ev_dlg.getjRBZeitPunkt().setSelected(true);
                ev_dlg.setEventtyp(2);
                ev_dlg.getjCBJahr_bis().setEnabled(false);
                ev_dlg.getjCBMonat_bis().setEnabled(false);
            }
            if (ev_searched.getStatus_ende() == 32) {
                ev_dlg.setjCB_Ende(32);
            } else {
                ev_dlg.setjCB_Ende(33);
            }
            ev_dlg.getjComboBox1().setSelectedIndex(ev_searched.getZeile());
            ev_dlg.getjTABeschreibung().setText(ev_searched.getText().replace("<br>", "\n").replace("<HTML>", "").replace("</HTML>", ""));
            ev_dlg.setVisible(true);
            if (ev_dlg.isOk()) {
                Polygon polygon_old = null;
                int zeile_alt = ev_searched.getZeile();
                if (ev_searched.isIS_MOVABLE()) {
                    polygon_old = ev_searched.getPolygon_movable();
                }
                this.mainFrame.saveDlgToEvent(ev_dlg, ev_searched);
                ev_searched.setStatus_row(16);
                this.event_handler.remove(ev_searched);
                try {
                    this.f_drawer.expandEvent(ev_searched);
                    this.event_handler.add(ev_searched);
                    for (Event e_for : this.getEvent_handler().getEvents()) {
                        if (e_for.getZeile() != zeile_alt) continue;
                        this.f_drawer.checkChangedEvent(e_for);
                    }
                    if (polygon_old != null && ev_searched.isIS_MOVABLE()) {
                        ev_searched.repositMovablePolygon(polygon_old.getBounds().x, polygon_old.getBounds().y);
                    }
                }
                catch (TooManyIntersectException tmie) {
                    System.out.println("TooManyIntersectException: " + tmie.getMessage() + "\n");
                    JOptionPane.showOptionDialog(null, "Falls diese Meldung erscheint, bitte ich Sie, den Fehler nachzubauen und eine Nachricht mit den Daten an den Programmierer weiter zu leiten. Mfg", "Bitte um Meldung", 1, -1, null, null, null);
                }
            }
            if (ev_dlg.isLoeschen()) {
                this.event_handler.remove(ev_searched);
            }
            this.mainFrame.repaint();
        }
    }

    public void mousePressed(MouseEvent e) {
        this.posX1 = e.getPoint().x;
        this.posY1 = e.getPoint().y;
        if (this.event_move == null) {
            Object ev_searched = null;
            for (Event event : this.event_handler.getEvents()) {
                if (!event.isIS_MOVABLE() || !event.getPolygon_movable().intersects(this.posX1, this.posY1, 1.0, 1.0)) continue;
                this.event_move = event;
                this.pol_X = event.getPolygon_movable().xpoints[0];
                this.pol_Y = event.getPolygon_movable().ypoints[0];
                return;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.posX1 >= 200 && this.posX2 >= 200 && this.posY1 >= 100 && this.posY2 >= 100) {
            String row_string;
            if (this.posX1 > this.posX2) {
                int swap = this.posX1;
                this.posX1 = this.posX2;
                this.posX2 = swap;
            }
            int months_pX1 = (this.posX1 - 200) / this.f_drawer.getDist_months();
            int months_pX2 = (this.posX2 - 200) / this.f_drawer.getDist_months();
            int yearX1 = this.getGb_jahr();
            int yearX2 = this.getGb_jahr();
            if (months_pX1 >= this.f_drawer.getTb_months_fy()) {
                if ((months_pX1 -= this.f_drawer.getTb_months_fy()) / 12 == 0) {
                    ++yearX1;
                } else {
                    yearX1 += months_pX1 / 12 + 1;
                    months_pX1 %= 12;
                }
            }
            if (months_pX2 >= this.f_drawer.getTb_months_fy()) {
                if ((months_pX2 -= this.f_drawer.getTb_months_fy()) / 12 == 0) {
                    ++yearX2;
                } else {
                    yearX2 += months_pX2 / 12 + 1;
                    months_pX2 %= 12;
                }
            }
            EventDlg e_dlg = new EventDlg((Frame)this.mainFrame, true);
            e_dlg.getjCBJahr_von().setSelectedItem(yearX1);
            e_dlg.getjCBJahr_bis().setSelectedItem(yearX2);
            e_dlg.getjCBMonat_von().setSelectedIndex(months_pX1);
            e_dlg.getjCBMonat_bis().setSelectedIndex(months_pX2);
            int row = (this.posY1 - 100) / 75;
            switch (row) {
                case 0: {
                    row_string = this.f_drawer.getLine01();
                    break;
                }
                case 1: {
                    row_string = this.f_drawer.getLine02();
                    break;
                }
                case 2: {
                    row_string = this.f_drawer.getLine03();
                    break;
                }
                case 3: {
                    row_string = this.f_drawer.getLine04();
                    break;
                }
                case 4: {
                    row_string = this.f_drawer.getLine05();
                    break;
                }
                case 5: {
                    row_string = this.f_drawer.getLine06();
                    break;
                }
                case 6: {
                    row_string = this.f_drawer.getLine07();
                    break;
                }
                case 7: {
                    row_string = this.f_drawer.getLine08();
                    break;
                }
                default: {
                    row_string = "";
                }
            }
            if (!row_string.equals("") && row_string != null) {
                System.out.println("row_string: " + row_string);
                e_dlg.getjComboBox1().setSelectedIndex((this.posY1 - 100) / 75);
                e_dlg.setVisible(true);
                if (e_dlg.isOk()) {
                    Event ev = new Event(this.event_handler);
                    this.mainFrame.saveDlgToEvent(e_dlg, ev);
                    try {
                        this.getEvent_handler().add(ev);
                    }
                    catch (TooManyIntersectException tmie) {
                        System.out.println("TooManyIntersectException: " + tmie.getMessage() + "\n");
                        JOptionPane.showMessageDialog(null, "Mehr als eine \u00dcberschneidung mit den Events. Darstellung nicht m\u00f6glich.", "\u00dcberschneidungsproblem", 2);
                    }
                }
            }
        }
        this.posY2 = 0;
        this.posY1 = 0;
        this.posX2 = 0;
        this.posX1 = 0;
        this.stateMouseDragged = false;
        this.event_move = null;
        this.mainFrame.repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (!this.stateMouseDragged) {
            this.posX1 = e.getPoint().x;
            this.posY1 = e.getPoint().y;
            this.stateMouseDragged = true;
        }
        if (this.event_move != null) {
            this.event_move.repositMovablePolygon(this.pol_X + (e.getPoint().x - this.posX1), this.pol_Y + (e.getPoint().y - this.posY1));
        } else {
            this.posX2 = e.getPoint().x;
            this.posY2 = e.getPoint().y;
        }
        this.mainFrame.repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public int getPosX1() {
        return this.posX1;
    }

    public int getPosX2() {
        return this.posX2;
    }

    public int getPosY1() {
        return this.posY1;
    }

    public int getPosY2() {
        return this.posY2;
    }

    public String getErstellDatum() {
        return this.erstellDatum;
    }

    public void setErstellDatum(String erstellDatum) {
        this.erstellDatum = erstellDatum;
    }

    public MainFrame getMainFrame() {
        this.getParent();
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }
}

