/*
 * Decompiled with CFR 0.152.
 */
package zeitbalken.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import zeitbalken.gui.FieldPanel;
import zeitbalken.logic.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FieldDrawer {
    private int width_panel = 1000;
    private int height_panel = 700;
    private int width_AllTimebars = this.width_panel - 200;
    FieldPanel f_panel;
    private String line01 = "Familie";
    private String line02 = "Wohnen";
    private String line03 = "Bildung";
    private String line04 = "Arbeit";
    private String line05 = "Gesundheit";
    private String line06 = "Behandl/Hilfe";
    private String line07 = "Sonstiges";
    private String line08 = "";
    private int tb_months_fy = 0;
    private int tb_months_ty = 0;
    private int tb_months_tn = 0;
    private int timebars = 0;
    private int tb_months = 0;
    private int dist_months = 0;
    private int dist_zeitpunkt = 100;
    private int dist_zeitpunkt_diff = 5;
    private FontMetrics font_metrics = new JLabel().getFontMetrics(new JLabel().getFont());
    private Color color_top = new Color(242, 220, 153);
    private Color color_firstColumn = new Color(242, 188, 27);
    private Color color_firstRow = new Color(242, 188, 27);
    private Color color_firstCell = new Color(242, 188, 27);
    private Color color_markedColumns = new Color(242, 220, 153);
    private Color color_left = new Color(255, 255, 255);
    private Color color_CutOff = new Color(223, 223, 223);
    private Color color_TextHeadline = new Color(0, 1, 0);
    private Color color_TextFirstColum = new Color(255, 255, 255);
    private Color color_TextFirstRows = new Color(0, 0, 0);
    private Color color_lines = new Color(0, 0, 0);
    private Color[] color_palette;

    public FieldDrawer(FieldPanel parent) {
        this.f_panel = parent;
        this.tb_months_fy = 13 - parent.getGb_monat();
        this.tb_months_ty = parent.getCurrent_monat();
        this.tb_months_tn = parent.getCurrent_jahr() - parent.getGb_jahr();
        if (this.tb_months_tn != 0) {
            this.tb_months_tn = (this.tb_months_tn - 1) * 12;
        }
        this.timebars = parent.getCurrent_jahr() - parent.getGb_jahr() + 1;
        this.tb_months = this.tb_months_fy + this.tb_months_tn + this.tb_months_ty;
        this.dist_months = this.width_AllTimebars / this.tb_months;
        this.colorChangerDlgStarting();
    }

    public void draw(Graphics g, List<Event> events) {
        Color color_bef = g.getColor();
        Graphics2D g2D = (Graphics2D)g;
        g.setColor(Color.BLACK);
        g.drawRect(0, 0, this.width_panel, this.height_panel);
        g.setColor(this.color_top);
        g.fillRect(0, 0, this.width_panel, this.height_panel);
        g.setColor(this.color_firstColumn);
        g.fillRect(0, 40, this.width_panel, 660);
        g.setColor(this.color_firstRow);
        g.fillRect(200, 40, this.width_panel - 200, 30);
        g.setColor(this.color_firstCell);
        g.fillRect(0, 40, 200, 30);
        g.setColor(this.color_left);
        g.fillRect(200, 70, this.width_panel - 200, 630);
        g.setColor(this.color_TextHeadline);
        g.setFont(g.getFont().deriveFont(25.0f));
        String s = "" + this.f_panel.getAnkerperson() + ", geb. " + this.f_panel.getGb_monat() + "." + this.f_panel.getGb_jahr() + "(" + this.f_panel.getAlter() + "a) in " + this.f_panel.getGeburtsort() + ".";
        g.drawString(s, 10, 30);
        int length_s = SwingUtilities.computeStringWidth(g.getFontMetrics(), s);
        g.setFont(g.getFont().deriveFont(17.0f));
        g.drawString("Interviewer: " + this.f_panel.getErsteller() + ", " + this.f_panel.getErstellDatum() + ".", 15 + length_s, 30);
        g.setColor(this.color_TextFirstColum);
        g.setFont(new Font(g.getFont().getName(), 1, 15));
        g.drawString("Alter", 10, 60);
        g.drawString("Jahr", 10, 90);
        g.setFont(g.getFont().deriveFont(25.0f));
        g.drawString(this.line01, 10, 150);
        g.drawString(this.line02, 10, 225);
        g.drawString(this.line03, 10, 300);
        g.drawString(this.line04, 10, 375);
        g.drawString(this.line05, 10, 450);
        g.drawString(this.line06, 10, 525);
        g.drawString(this.line07, 10, 600);
        g.drawString(this.line08, 10, 675);
        g.setFont(g.getFont().deriveFont(12.0f));
        int age = 0;
        for (int i = this.tb_months_fy; i <= this.tb_months; ++i) {
            if ((i + 12 - this.tb_months_fy) % 12 != 0) continue;
            g.setColor(this.color_lines);
            g.drawLine(200 + this.dist_months * i, 40, 200 + this.dist_months * i, this.height_panel);
            if (age % 5 == 0) {
                g.setColor(this.color_markedColumns);
                if (i < 13) {
                    g.fillRect(201, 40, this.dist_months * i, 660);
                } else {
                    g.fillRect(201 + this.dist_months * (i - 12), 40, this.dist_months * 12 - 1, 660);
                }
            }
            this.draw_infowrapper(i, g, age, this.dist_months, this.timebars);
            ++age;
        }
        if (this.tb_months_ty >= 6) {
            if (age % 5 == 0) {
                g.setColor(this.color_markedColumns);
                g.fillRect(202 + this.dist_months * (this.tb_months - 12), 40, this.dist_months * 12 - 1, 660);
            }
            this.draw_infowrapper(this.tb_months - this.tb_months_ty + 9, g, age, this.dist_months, this.timebars);
        }
        g.setColor(this.color_lines);
        g.drawLine(0, 40, this.width_panel, 40);
        g.drawLine(0, 70, this.width_panel, 70);
        g.drawLine(0, 100, this.width_panel, 100);
        g.drawLine(0, 175, this.width_panel, 175);
        g.drawLine(0, 250, this.width_panel, 250);
        g.drawLine(0, 325, this.width_panel, 325);
        g.drawLine(0, 400, this.width_panel, 400);
        g.drawLine(0, 475, this.width_panel, 475);
        g.drawLine(0, 550, this.width_panel, 550);
        g.drawLine(0, 625, this.width_panel, 625);
        g.drawLine(200, 40, 200, this.height_panel);
        g.setColor(this.color_CutOff);
        g.fillRect(200 + this.dist_months * this.tb_months, 40, this.width_panel - (200 + this.dist_months * this.tb_months), 660);
        g.setColor(Color.BLACK);
        for (Event e : events) {
            if (e.getStatus_event() == 2) {
                g.setColor(Color.RED);
                g.drawLine(e.getPosXPunkt(), e.getPosYPunkt(), e.getPosXPunkt(), e.getPosYPunkt() + e.getHeightPunkt());
                g.drawLine(e.getPosXPunkt() - 1, e.getPosYPunkt(), e.getPosXPunkt() - 1, e.getPosYPunkt() + e.getHeightPunkt());
                g.drawLine(e.getPosXPunkt() + 1, e.getPosYPunkt(), e.getPosXPunkt() + 1, e.getPosYPunkt() + e.getHeightPunkt());
                g.setColor(Color.BLACK);
            }
            if (e.getPolygon() == null) {
                e.setWidth(e.getWidth());
            }
            if (e.getPolygon() == null) continue;
            if (e.getStatus_event() != 2 || !e.isIS_MOVABLE()) {
                g.setColor(Color.WHITE);
                g.fillPolygon(e.getPolygon());
                g.setColor(Color.BLACK);
                g.drawPolygon(e.getPolygon());
            }
            if (!e.isIS_MOVABLE()) continue;
            if (e.getStatus_event() == 2) {
                g.setColor(new Color(8379391));
            } else {
                g.setColor(new Color(223, 223, 223));
            }
            g.fillPolygon(e.getPolygon_movable());
            g.setColor(Color.BLACK);
            if (!e.getPolygon().intersects(e.getPolygon_movable().getBounds())) {
                this.drawArrow(g, e);
            }
            if (e.getStatus_event() != 2 || e.getPolygon_movable().intersects(e.getPosXPunkt(), e.getPosYPunkt(), 3.0, e.getHeightPunkt())) continue;
            this.drawArrow(g, e);
        }
        for (Event e : events) {
            if (e.getPolygon() == null || e.getStatus_event() != 2 || !e.isIS_MOVABLE()) continue;
            g.setColor(new Color(8379391));
            g.fillPolygon(e.getPolygon_movable());
        }
        g.setColor(Color.BLACK);
        this.drawRectMouseDragged(g, this.f_panel.getPosX1(), this.f_panel.getPosY1(), this.f_panel.getPosX2(), this.f_panel.getPosY2());
        g.setColor(color_bef);
    }

    private void drawArrow(Graphics g, Event e) {
        if (!e.isIS_MOVABLE()) {
            return;
        }
        int[] x = new int[4];
        int[] y = new int[4];
        Point oben = new Point(e.getPosX() + e.getWidth() / 2, e.getPosY());
        Point rechts = new Point(e.getPosX() + e.getWidth(), e.getPosY() + e.getHeight() / 2);
        Point unten = new Point(e.getPosX() + e.getWidth() / 2, e.getPosY() + e.getHeight());
        Point links = new Point(e.getPosX(), e.getPosY() + e.getHeight() / 2);
        Point movOben = new Point(e.getPolygon_movable().getBounds().x + e.getPolygon_movable().getBounds().width / 2, e.getPolygon_movable().getBounds().y);
        Point movRechts = new Point(e.getPolygon_movable().getBounds().x + e.getPolygon_movable().getBounds().width, e.getPolygon_movable().getBounds().y + e.getPolygon_movable().getBounds().height / 2);
        Point movUnten = new Point(e.getPolygon_movable().getBounds().x + e.getPolygon_movable().getBounds().width / 2, e.getPolygon_movable().getBounds().y + e.getPolygon_movable().getBounds().height);
        Point movLinks = new Point(e.getPolygon_movable().getBounds().x, e.getPolygon_movable().getBounds().y + e.getPolygon_movable().getBounds().height / 2);
        Point[] PolPoints = new Point[]{oben, rechts, unten, links};
        Point[] MovPoints = new Point[]{movOben, movRechts, movUnten, movLinks};
        double dist_between_points = 0.0;
        double dist_between_points_smallest = Double.MAX_VALUE;
        for (Point p : PolPoints) {
            for (Point m : MovPoints) {
                dist_between_points = (p.x - m.x) * (p.x - m.x) + (p.y - m.y) * (p.y - m.y);
                if (!(dist_between_points < dist_between_points_smallest)) continue;
                x[0] = p.x;
                y[0] = p.y;
                x[1] = m.x;
                y[1] = m.y;
                dist_between_points_smallest = dist_between_points;
            }
        }
        if (e.getStatus_event() == 2) {
            x[0] = e.getPosXPunkt();
            y[0] = e.getPosYPunkt() + e.getHeightPunkt() / 2;
        }
        x[1] = x[1] - x[0];
        y[1] = y[1] - y[0];
        double len = Math.sqrt(x[1] * x[1] + y[1] * y[1]);
        x[2] = x[3] = (int)((double)(x[1] * 10) / len);
        int x_swap = x[3];
        y[2] = y[3] = (int)((double)(y[1] * 10) / len);
        int y_swap = y[3];
        x[2] = x[2] + -y_swap;
        y[2] = y[2] + x_swap;
        x[3] = x[3] + y_swap;
        y[3] = y[3] + -x_swap;
        Color c = g.getColor();
        g.setColor(Color.BLACK);
        g.drawLine(x[0], y[0], x[0] + x[1], y[0] + y[1]);
        g.drawLine(x[0], y[0], x[0] + x[2], y[0] + y[2]);
        g.drawLine(x[0], y[0], x[0] + x[3], y[0] + y[3]);
        g.setColor(c);
    }

    private void drawRectMouseDragged(Graphics g, int posX1, int posY1, int posX2, int posY2) {
        Graphics2D g2 = (Graphics2D)g;
        if (posX1 <= 200 || posX2 <= 200 || posY1 <= 100 || posY2 <= 100) {
            return;
        }
        Stroke bstroke = g2.getStroke();
        g2.setStroke(new BasicStroke(3.0f, 0, 2, 10.0f, new float[]{4.0f}, 0.0f));
        if (posX1 < posX2) {
            g2.drawLine(posX1, posY1, posX2, posY1);
        } else {
            g2.drawLine(posX2, posY1, posX1, posY1);
        }
        g2.setStroke(bstroke);
    }

    private void draw_infowrapper(int num_months, Graphics g, int age, int dist_months, int timebars) {
        if (num_months < 6) {
            return;
        }
        g.setColor(this.color_TextFirstRows);
        g.drawString("" + age, 200 + dist_months * num_months - SwingUtilities.computeStringWidth(g.getFontMetrics(), "" + num_months / 12) - 1, 60);
        int jahr = this.f_panel.getGb_jahr() + age;
        g.drawString("" + jahr / 100, 200 + dist_months * num_months - SwingUtilities.computeStringWidth(g.getFontMetrics(), "" + (this.f_panel.getGb_jahr() + timebars) / 100) - 1, 82);
        String jahr_sec = (jahr %= 100) < 10 ? "0" + jahr : "" + jahr;
        g.drawString(jahr_sec, 200 + dist_months * num_months - SwingUtilities.computeStringWidth(g.getFontMetrics(), jahr_sec) - 1, 97);
        g.setColor(Color.BLACK);
    }

    public void handleEvent(Event e) {
        int pos_anfang = 201 + this.countMonths(this.f_panel.getGb_jahr(), this.f_panel.getGb_monat() + 1, e.getJahr_von(), e.getMonat_von() + 1) * this.dist_months;
        int pos_ende = 201 + this.countMonths(this.f_panel.getGb_jahr(), this.f_panel.getGb_monat() + 1, e.getJahr_bis(), e.getMonat_bis() + 1) * this.dist_months;
        e.setPosY(180 + 75 * (e.getZeile() - 1));
        if (e.getStatus_row() == 16) {
            e.setHeight(65);
        } else {
            e.setHeight(30);
        }
        e.setPosX(pos_anfang);
        if (e.getStatus_event() == 1) {
            e.setWidth(pos_ende - pos_anfang);
        } else {
            e.setPosXPunkt(pos_anfang);
            e.setPosYPunkt(e.getPosY());
            e.setWidth(this.dist_zeitpunkt);
        }
        if (e.getWidth() < this.font_metrics.stringWidth(e.getTextNonHTML()) || e.getStatus_event() == 2) {
            e.setIS_MOVABLE(true);
            return;
        }
        e.setIS_MOVABLE(false);
        e.getjLabel_text().setBounds(e.getPosX(), e.getPosY(), e.getWidth(), e.getHeight());
        e.getjLabel_text().setHorizontalAlignment(0);
        e.getjLabel_text().setVisible(true);
    }

    public void expandEvent(Event e) {
        int pos_anfang = 201 + this.countMonths(this.f_panel.getGb_jahr(), this.f_panel.getGb_monat() + 1, e.getJahr_von(), e.getMonat_von() + 1) * this.dist_months;
        int pos_ende = 201 + this.countMonths(this.f_panel.getGb_jahr(), this.f_panel.getGb_monat() + 1, e.getJahr_bis(), e.getMonat_bis() + 1) * this.dist_months;
        e.setPosX(pos_anfang);
        if (e.getStatus_event() == 1) {
            e.setWidth(pos_ende - pos_anfang);
        } else {
            e.setPosXPunkt(pos_anfang);
            e.setPosYPunkt(e.getPosY());
            e.setWidth(this.dist_zeitpunkt);
        }
        if (e.getWidth() < this.font_metrics.stringWidth(e.getTextNonHTML()) || e.getStatus_event() == 2) {
            e.setIS_MOVABLE(true);
            return;
        }
        e.setIS_MOVABLE(false);
        e.getjLabel_text().setBounds(e.getPosX(), e.getPosY(), e.getWidth(), e.getHeight());
        e.getjLabel_text().setHorizontalAlignment(0);
        e.getjLabel_text().setVisible(true);
    }

    public void checkChangedEvent(Event e) {
        int status_row = e.getStatus_row();
        List<Event> events = this.f_panel.getEvent_handler().getEvents();
        boolean has_intersects = false;
        if (status_row == 17 || status_row == 18) {
            for (Event ev_int : events) {
                if (!this.f_panel.getEvent_handler().intersect(ev_int, e) || e.equals(ev_int)) continue;
                has_intersects = true;
                break;
            }
            if (!has_intersects) {
                e.setStatus_row(16);
            }
        } else {
            for (Event ev_int : events) {
                if (this.f_panel.getEvent_handler().intersect(ev_int, e)) {
                    has_intersects = true;
                    break;
                }
                if (!has_intersects) continue;
            }
        }
    }

    private int countMonths(int startYear, int startMonth, int endYear, int endMonth) {
        if (endYear < startYear) {
            return 0;
        }
        if (endYear == startYear) {
            if (endMonth <= startMonth) {
                return 0;
            }
            return endMonth - startMonth + 1;
        }
        int months = 13 - startMonth;
        int months_between = endYear - startYear;
        if (months_between != 0) {
            months_between = (months_between - 1) * 12;
        }
        return months += months_between + endMonth;
    }

    public void colorChangerDlgClosing(boolean isOK) {
        if (!isOK) {
            this.color_top = this.color_palette[0];
            this.color_firstColumn = this.color_palette[1];
            this.color_firstRow = this.color_palette[2];
            this.color_firstCell = this.color_palette[3];
            this.color_markedColumns = this.color_palette[4];
            this.color_left = this.color_palette[5];
            this.color_CutOff = this.color_palette[6];
            this.color_TextHeadline = this.color_palette[7];
            this.color_TextFirstColum = this.color_palette[8];
            this.color_TextFirstRows = this.color_palette[9];
            this.color_lines = this.color_palette[10];
            this.f_panel.getMainFrame().repaint();
        } else {
            this.f_panel.getMainFrame().saveProperties();
        }
    }

    public void colorChangerDlgStarting() {
        this.color_palette = new Color[]{this.color_top, this.color_firstColumn, this.color_firstRow, this.color_firstCell, this.color_markedColumns, this.color_left, this.color_CutOff, this.color_TextHeadline, this.color_TextFirstColum, this.color_TextFirstRows, this.color_lines};
    }

    public int getHeightPanel() {
        return this.height_panel;
    }

    public void setHeightPanel(int height) {
        this.height_panel = height;
        this.f_panel.setSize(this.width_panel, this.height_panel);
    }

    public int getWidthPanel() {
        return this.width_panel;
    }

    public void setWidthPanelFDrawer(int width) {
        int width_old = this.width_panel;
        this.width_panel = width;
        this.width_AllTimebars = this.width_panel - 200;
        this.f_panel.setSize(this.width_panel, this.height_panel);
        this.f_panel.setPreferredSize(new Dimension(this.width_panel, this.height_panel));
        this.dist_months = this.width_AllTimebars / this.tb_months;
        for (int i = 0; i < this.f_panel.getEvent_handler().getEvents().size(); ++i) {
            Event e = this.f_panel.getEvent_handler().getEvents().get(i);
            int distX = 0;
            int distY = 0;
            if (e.isIS_MOVABLE()) {
                if (e.getStatus_event() == 1) {
                    distX = e.getPolygon_movable().xpoints[0] - e.getPosX();
                    distY = e.getPolygon_movable().ypoints[0] - e.getPosY();
                } else {
                    distX = e.getPolygon_movable().xpoints[0] - e.getPosXPunkt();
                    distY = e.getPolygon_movable().ypoints[0] - e.getPosYPunkt();
                }
            }
            int status = e.getStatus_row();
            this.expandEvent(e);
            if (e.isIS_MOVABLE()) {
                if (e.getStatus_event() == 1) {
                    e.repositMovablePolygon(e.getPosX() + distX, e.getPosY() + distY);
                } else {
                    e.repositMovablePolygon(e.getPosXPunkt() + distX, e.getPosYPunkt() + distY);
                }
            }
            e.setStatus_row(status);
        }
        this.f_panel.validate();
    }

    public int getDist_months() {
        return this.dist_months;
    }

    public String getLine01() {
        return this.line01;
    }

    public String getLine02() {
        return this.line02;
    }

    public String getLine03() {
        return this.line03;
    }

    public String getLine04() {
        return this.line04;
    }

    public String getLine05() {
        return this.line05;
    }

    public String getLine06() {
        return this.line06;
    }

    public String getLine07() {
        return this.line07;
    }

    public String getLine08() {
        return this.line08;
    }

    public void setLine01(String line01) {
        this.line01 = line01;
    }

    public void setLine02(String line02) {
        this.line02 = line02;
    }

    public void setLine03(String line03) {
        this.line03 = line03;
    }

    public void setLine04(String line04) {
        this.line04 = line04;
    }

    public void setLine05(String line05) {
        this.line05 = line05;
    }

    public void setLine06(String line06) {
        this.line06 = line06;
    }

    public void setLine07(String line07) {
        this.line07 = line07;
    }

    public void setLine08(String line08) {
        this.line08 = line08;
    }

    public int getTb_months_fy() {
        return this.tb_months_fy;
    }

    public int getTb_months_tn() {
        return this.tb_months_tn;
    }

    public int getTb_months_ty() {
        return this.tb_months_ty;
    }

    public FontMetrics getFont_metrics() {
        return this.font_metrics;
    }

    public Color getColor_CutOff() {
        return this.color_CutOff;
    }

    public void setColor_CutOff(Color color_CutOff) {
        this.color_CutOff = color_CutOff;
    }

    public Color getColor_TextFirstColum() {
        return this.color_TextFirstColum;
    }

    public void setColor_TextFirstColum(Color color_TextFirstColum) {
        this.color_TextFirstColum = color_TextFirstColum;
    }

    public Color getColor_TextFirstRows() {
        return this.color_TextFirstRows;
    }

    public void setColor_TextFirstRows(Color color_TextFirstRows) {
        this.color_TextFirstRows = color_TextFirstRows;
    }

    public Color getColor_TextHeadline() {
        return this.color_TextHeadline;
    }

    public void setColor_TextHeadline(Color color_TextHeadline) {
        this.color_TextHeadline = color_TextHeadline;
    }

    public Color getColor_firstCell() {
        return this.color_firstCell;
    }

    public void setColor_firstCell(Color color_firstCell) {
        this.color_firstCell = color_firstCell;
    }

    public Color getColor_firstColumn() {
        return this.color_firstColumn;
    }

    public void setColor_firstColumn(Color color_firstColumn) {
        this.color_firstColumn = color_firstColumn;
    }

    public Color getColor_firstRow() {
        return this.color_firstRow;
    }

    public void setColor_firstRow(Color color_firstRow) {
        this.color_firstRow = color_firstRow;
    }

    public Color getColor_left() {
        return this.color_left;
    }

    public void setColor_left(Color color_left) {
        this.color_left = color_left;
    }

    public Color getColor_lines() {
        return this.color_lines;
    }

    public void setColor_lines(Color color_lines) {
        this.color_lines = color_lines;
    }

    public Color getColor_markedColumns() {
        return this.color_markedColumns;
    }

    public void setColor_markedColumns(Color color_markedColumns) {
        this.color_markedColumns = color_markedColumns;
    }

    public Color getColor_top() {
        return this.color_top;
    }

    public void setColor_top(Color color_top) {
        this.color_top = color_top;
    }

    public Color[] getColor_palette() {
        return this.color_palette;
    }
}

